let deferredPrompt;
const installPopup = document.getElementById("installPopup");
const installBtn = document.getElementById("installBtn");
const closeBtn = document.getElementById("closeBtn");

window.addEventListener("beforeinstallprompt", (e) => {
  // Prevent automatic prompt
  e.preventDefault();
  deferredPrompt = e;
  installPopup.style.display = "flex";
});

installBtn.addEventListener("click", async () => {
  installPopup.style.display = "none";
  if (deferredPrompt) {
    deferredPrompt.prompt();
    const choice = await deferredPrompt.userChoice;
    if (choice.outcome === "accepted") {
      console.log("User installed the app");
    } else {
      console.log("User dismissed the install prompt");
    }
    deferredPrompt = null;
  }
});

closeBtn.addEventListener("click", () => {
  installPopup.style.display = "none";
});

// Register Service Worker
if ("serviceWorker" in navigator) {
  navigator.serviceWorker.register("sw.js").then(() => {
    console.log("Service Worker registered");
  });
}
